// ==UserScript==
// @name         Recolor Canvas
// @namespace    http://tampermonkey.net/
// @version      2025-04-23
// @description  Try different colors on a Canvas page
// @author       You
// @match        https://uia.instructure.com/courses/*/pages/*
// @icon         data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==
// @grant        none
// ==/UserScript==

(function() {
    'use strict';

    // Your code here...
    /* GLOBAL VARIABLES */
    let elementsC = [];
    let elementsBg = [];
    // Border colors:
    let elementsBt = [];
    let elementsBr = [];
    let elementsBb = [];
    let elementsBl = [];

    // Add a mutation observer to wait for the header
    const observer = new MutationObserver((mutations, observer)=>{
        for(const mutation of mutations){
            const pageTitle = document.querySelector("h1");
            if(pageTitle){
                observer.disconnect();
                addToolbar(pageTitle);
                return;
            }
        }
    });

    observer.observe(document.body, {subtree: true, childList: true});

    function addToolbar(pageTitle){
        // Create and add toolbar
        const toolbar = document.createElement("div");
        toolbar.setAttribute("id", "uia__color_toolbar");
        toolbar.style.backgroundColor = "ALICEBLUE";
        toolbar.style.padding = "1rem";
        toolbar.style.display = "flex";
        toolbar.style.alignItems = "center";
        toolbar.innerText = "Colors on this page:";
        pageTitle.insertAdjacentElement("beforebegin", toolbar);

        // Get colors on the page
        let colors = getColorsOnPage();

        if(colors.length > 0){
            console.log(colors);
            // Add color picker for each color in the toolbar
            addColorsInToolbar(colors, toolbar);

            // Add a button to reset all colors
            const resetBtn = document.createElement("button");
            resetBtn.innerText = "Reset Colors";
            resetBtn.classList.add("btn", "btn-info");
            resetBtn.style.margin = "0 1rem";
            toolbar.appendChild(resetBtn);
            resetBtn.addEventListener("click", resetColors);
        } else {
            let p = document.createElement("p");
            p.innerText = "No changable colors found";
            p.style.margin = "0 1rem";
            toolbar.appendChild(p);
        }


    }

    function getColorsOnPage(){
        const page = document.querySelector(".user_content");
        let allPageElements = page.querySelectorAll("*");
        let colors = [];

        for(const child of allPageElements){

            if(child.id !== "uia__color_toolbar"){
                if(child.style.color){
                    colors.push(child.style.color);
                    let colorExists = elementsC.find(e => e.color === child.style.color);
                    colorExists ? colorExists.nodes.push(child) : elementsC.push({"color": child.style.color, nodes: [child]});
                }
                if(child.style.backgroundColor){
                    colors.push(child.style.backgroundColor);
                    let bgColorExists = elementsBg.find(e => e.color === child.style.backgroundColor);
                    bgColorExists ? bgColorExists.nodes.push(child) : elementsBg.push({"color": child.style.backgroundColor, nodes: [child]});
                }
                if(child.style.borderTopColor){
                    colors.push(child.style.borderTopColor);
                    let btColorExists = elementsBt.find(e => e.color === child.style.borderTopColor);
                    btColorExists ? btColorExists.nodes.push(child) : elementsBt.push({"color": child.style.borderTopColor, nodes: [child]});
                }
                if(child.style.borderRightColor){
                    colors.push(child.style.borderRightColor);
                    let brColorExists = elementsBr.find(e => e.color === child.style.borderRightColor);
                    brColorExists ? brColorExists.nodes.push(child) : elementsBr.push({"color": child.style.borderRightColor, nodes: [child]});
                }
                if(child.style.borderBottomColor){
                    colors.push(child.style.borderBottomColor);
                    let bbColorExists = elementsBb.find(e => e.color === child.style.borderBottomColor);
                    bbColorExists ? bbColorExists.nodes.push(child) : elementsBb.push({"color": child.style.borderBottomColor, nodes: [child]});
                }
                if(child.style.borderLeftColor){
                    colors.push(child.style.borderLeftColor);
                    let blColorExists = elementsBl.find(e => e.color === child.style.borderLeftColor);
                    blColorExists ? blColorExists.nodes.push(child) : elementsBl.push({"color": child.style.borderLeftColor, nodes: [child]});
                }
            }
        }

        // Only retain unique colors
        let uniqueColors = new Set(colors);
        colors = [...uniqueColors];

        // Remove any values that aren't explicit colors, like unset
        colors = colors.filter(c => c.includes("rgb"));
        return colors;
    }

    function addColorsInToolbar(colors, toolbar){
        for(let color of colors){
            let colorPicker = document.createElement("input");
            colorPicker.setAttribute("type", "color");
            colorPicker.setAttribute("value", rgbToHex(color));
            colorPicker.setAttribute("data-original-color", color);
            colorPicker.style.width = "45px";
            colorPicker.style.height = "25px";
            colorPicker.style.padding = "0";
            colorPicker.style.margin = "0 0.5rem";
            toolbar.appendChild(colorPicker);

            colorPicker.addEventListener("change", changeColor);
        }
    }

    function changeColor(e){
        let originalColor = e.target.getAttribute("data-original-color");

        // Change all colors
        let currentColorElements = elementsC.find(c => c.color === originalColor);
        if(currentColorElements){
            for(const elC of currentColorElements.nodes){
                elC.style.color = e.target.value;
            }
        }
        // Change all background colors
        let currentBackgroundElements = elementsBg.find(b => b.color === originalColor);
        if(currentBackgroundElements){
            for(const elBg of currentBackgroundElements.nodes){
                elBg.style.backgroundColor = e.target.value;
            }
        }

        // Change all border colors
        let currentBtElements = elementsBt.find(b => b.color === originalColor);
        if(currentBtElements){
            for(const elBt of currentBtElements.nodes){
                elBt.style.borderTopColor = e.target.value;
            }
        }

        let currentBrElements = elementsBr.find(b => b.color === originalColor);
        if(currentBtElements){
            for(const elBr of currentBrElements.nodes){
                elBr.style.borderRightColor = e.target.value;
            }
        }

        let currentBbElements = elementsBb.find(b => b.color === originalColor);
        if(currentBbElements){
            for(const elBb of currentBbElements.nodes){
                elBb.style.borderBottomColor = e.target.value;
            }
        }

        let currentBlElements = elementsBl.find(b => b.color === originalColor);
        if(currentBlElements){
            for(const elBl of currentBlElements.nodes){
                elBl.style.borderLeftColor = e.target.value;
            }
        }
    }

    function resetColors(){
        // Reset all colors on page
        let allElements = combineElements();
        for(const item of allElements){
            let color = item.color;
            let type = item.type;
            for(const node of item.nodes){
                switch(type){
                    case "c":
                        node.style.color = color;
                        break;
                    case "bg":
                        node.style.backgroundColor = color;
                        break;
                    case "bt":
                        node.style.borderTopColor = color;
                        break;
                    case "br":
                        node.style.borderRightColor = color;
                        break;
                    case "bb":
                        node.style.borderBottomColor = color;
                        break;
                    case "bl":
                        node.style.borderLeftColor = color;
                        break;
                    default:
                        console.log("No valid type found");
                        break;
                }
            }
        }

        // Reset color picker colors
        let colorPickers = document.querySelectorAll('input[type="color"]');
        colorPickers.forEach(picker => {
            let oc = picker.getAttribute("data-original-color");
            picker.value = rgbToHex(oc);
        });
    }

    function combineElements(){
        let all = [];
        for(const c of elementsC){
            c.type = "c";
            all.push(c);
        }
        for(const bg of elementsBg){
            bg.type = "bg";
            all.push(bg);
        }
        for(const bt of elementsBt){
            bt.type = "bt";
            all.push(bt);
        }
        for(const br of elementsBr){
            br.type = "br";
            all.push(br);
        }
        for(const bb of elementsBb){
            bb.type = "bb";
            all.push(bb);
        }
        for(const bl of elementsBl){
            bl.type = "bl";
            all.push(bl);
        }
        return all;
        //return elementsC.concat(elementsBg, elementsBt, elementsBr, elementsBb, elementsBl);
    }

    function rgbToHex(rgb) {
        // Extract the numbers from the rgb string
        let result = rgb.match(/\d+/g);

        // Convert each number to a two-digit hex string
        let r = parseInt(result[0]).toString(16).padStart(2, '0');
        let g = parseInt(result[1]).toString(16).padStart(2, '0');
        let b = parseInt(result[2]).toString(16).padStart(2, '0');

        // Combine the hex values into a single string
        return `#${r}${g}${b}`;
    }

})();